<?php

add_action( 'bizberg_before_homepage_blog', 'ngo_charity_hub_homepage_services' );
function ngo_charity_hub_homepage_services(){

	$status            = bizberg_get_theme_mod( 'services_status' );
	$services_subtitle = bizberg_get_theme_mod( 'services_subtitle' );
	$services_title    = bizberg_get_theme_mod( 'services_title' );

	if( $status == false ){
		return;
	}

	$ngo_charity_hub_services = bizberg_get_theme_mod( 'ngo_charity_hub_services' );
	$ngo_charity_hub_services = json_decode( $ngo_charity_hub_services, true ); ?>

	<div class="services_wrapper">

		<div class="container">

			<div class="title_wrapper">			
				<h4><?php echo esc_html( $services_subtitle ); ?></h4>
				<h2><?php echo esc_html( $services_title ); ?></h2>
			</div>

			<div class="item_wrapper">

				<?php 

				foreach( $ngo_charity_hub_services as $value ){

					$icon    = !empty( $value['icon'] ) ? $value['icon'] : '';
					$page_id = !empty( $value['page_id'] ) ? $value['page_id'] : '';

					$pageobj = get_post( $page_id ); ?>

					<div class="col-lg-4 col-md-6">
					
						<div class="main-services-item">

							<div class="icon">
								<i class="<?php echo esc_attr( $icon ); ?>"></i>
							</div>

							<h3>
								<a href="<?php echo esc_url( get_permalink( $page_id ) ); ?>"><?php echo esc_html( $pageobj->post_title ); ?></a>
							</h3>

							<p><?php echo esc_html( wp_trim_words( sanitize_text_field( $pageobj->post_content ), 15, null ) ); ?></p>

							<img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/img/services-shape.png" class="services-shape">

						</div>

					</div>

					<?php 

				} ?>

			</div>

		</div>
		
	</div>

	<?php
}