<?php

add_action( 'bizberg_before_homepage_blog', 'ngo_charity_hub_about_us' );
function ngo_charity_hub_about_us(){ 

	$page_id        = bizberg_get_theme_mod( 'about_page' );
	$about_subtitle = bizberg_get_theme_mod( 'about_subtitle' );

	if( empty( $page_id ) ){
		return;
	}

	$pageobj           = get_post( $page_id ); 
	$post_thumbnail_id = get_post_thumbnail_id( $page_id );
	$image_url         = wp_get_attachment_url( $post_thumbnail_id );

	?>

	<div class="about_wrapper">
		
		<div class="container">

			<div class="col-lg-12 col-md-12">
			
				<div class="about_wrapper_inner">	

					<div class="left">
						<h4><?php echo esc_html( $about_subtitle ); ?></h4>
						<h2><?php echo esc_html( $pageobj->post_title ); ?></h2>
						<p><?php echo esc_html( sanitize_text_field( wp_trim_words( $pageobj->post_content, 55, ' [...]' ) ) ); ?></p>
						<a 
						href="<?php echo esc_url( get_permalink( $page_id ) ); ?>" 
						class="main-btn"><span class="btn-style"><?php esc_html_e( 'Read More' , 'ngo-charity-hub' ); ?></span></a>
					</div>
					<div class="right" style="background-image:url(<?php echo esc_url( $image_url ); ?>)">
						
					</div>		
					
				</div>

			</div>

		</div>

	</div>

	<?php
}