<?php

add_action( 'init' , 'ngo_charity_hub_services' );
function ngo_charity_hub_services(){

	Kirki::add_section( 'ngo_charity_hub_services', array(
        'title'   => esc_html__( 'Services', 'ngo-charity-hub' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', [
		'type'        => 'checkbox',
		'settings'    => 'services_status',
		'label'       => esc_html__( 'Enable / Disable', 'ngo-charity-hub' ),
		'section'     => 'ngo_charity_hub_services',
		'default'     => false,
	] );

    Kirki::add_field( 'bizberg', [
		'type'     => 'text',
		'settings' => 'services_subtitle',
		'label'    => esc_html__( 'Subtitle', 'ngo-charity-hub' ),
		'section'  => 'ngo_charity_hub_services',
		'default'  => esc_html__( 'Our Best Service', 'ngo-charity-hub' ),
		'active_callback' => [
			[
				'setting'  => 'services_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'bizberg', [
		'type'     => 'text',
		'settings' => 'services_title',
		'label'    => esc_html__( 'Title', 'ngo-charity-hub' ),
		'section'  => 'ngo_charity_hub_services',
		'default'  => esc_html__( 'Service We Can With', 'ngo-charity-hub' ),
		'active_callback' => [
			[
				'setting'  => 'services_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'bizberg', array(
    	'type'        => 'advanced-repeater',
    	'label'       => esc_html__( 'Services', 'ngo-charity-hub' ),
	    'section'     => 'ngo_charity_hub_services',
	    'settings'    => 'ngo_charity_hub_services',
	    'active_callback' => [
			[
				'setting'  => 'services_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	    'choices' => [
	        'button_label' => esc_html__( 'Add Services', 'ngo-charity-hub' ),
	        'row_label' => [
	            'value' => esc_html__( 'Services', 'ngo-charity-hub' ),
	        ],
	        'limit'  => 4,
	        'fields' => [
	        	'icon'  => [
	                'type'        => 'fontawesome',
	                'label'       => esc_html__( 'Icon', 'ngo-charity-hub' ),
	                'default'     => 'fab fa-accusoft',
	                'choices'     => bizberg_get_fontawesome_options(),
	            ],
	            'page_id' => [
	                'type'        => 'select',
	                'label'       => esc_html__( 'Page', 'ngo-charity-hub' ),
	                'choices'     => bizberg_get_all_pages()
	            ],
	        ],
	    ]
    ));

}